<?php 
session_start(); 
if(!isset($_SESSION['admin'])) header("Location: index.php"); 
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>ממשק ניהול - GOD MODE</title>
    <link rel="stylesheet" href="ai-system/style.css">
    <style>
        body { margin:0; overflow:hidden; display:flex; flex-direction:column; height:100vh; background:#111; color:white; }
        .top-bar { background:#222; padding:10px; display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid #444; }
        .main-grid { display:grid; grid-template-columns: 300px 1fr 300px; flex:1; overflow:hidden; }
        .panel { border-left:1px solid #333; display:flex; flex-direction:column; background:rgba(0,0,0,0.2); }
        .panel-head { background:#1a1a1a; padding:10px; font-weight:bold; border-bottom:1px solid #333; color:#0f0; }
        .scroll-area { flex:1; overflow-y:auto; padding:10px; }
        
        .user-row { padding:10px; border-bottom:1px solid #333; background:#222; margin-bottom:5px; border-radius:5px; }
        .worker-select { background:#000; color:white; border:1px solid #555; padding:3px; width:100%; margin-top:5px; }
        .status-dot { height: 10px; width: 10px; background-color: #bbb; border-radius: 50%; display: inline-block; }
        .online { background-color: #0f0; }
        .offline { background-color: #f00; }
    </style>
</head>
<body>

<div class="top-bar">
    <div>⚡ <b>GOD MODE ADMIN</b></div>
    <button onclick="location.href='index.php'" style="background:red; width:auto; padding:5px 15px;">יציאה</button>
</div>

<div class="main-grid">
    
    <div class="panel">
        <div class="panel-head">🔌 עובדים מחוברים (Workers)</div>
        <div id="workersList" class="scroll-area" style="max-height: 150px; border-bottom: 1px solid #444;">
            </div>

        <div class="panel-head">👥 ניתוב משתמשים</div>
        <div id="usersList" class="scroll-area"></div>
    </div>

    <div class="panel">
        <div class="panel-head">⚡ מסוף שליטה (ROOT)</div>
        <div id="myChat" class="scroll-area" style="background:black; font-family:monospace;"></div>
        <div class="input-zone">
            <input type="text" id="adminInput" placeholder="פקודה למערכת..." onkeypress="if(event.key==='Enter') sendAdmin()">
            <button onclick="sendAdmin()">🚀</button>
        </div>
    </div>

    <div class="panel">
        <div class="panel-head">🎛️ הגדרות כלליות</div>
        <div style="padding:10px;">
            <label><input type="checkbox" id="chkInternet" onchange="saveSettings()"> 🌐 אינטרנט</label><br>
            <label><input type="checkbox" id="chkNsfw" onchange="saveSettings()"> 🔞 ללא צנזורה</label>
        </div>
        
        <div class="panel-head">👁️ צפייה בצ'אט: <span id="spyName">...</span></div>
        <div id="spyChat" class="scroll-area" style="background:#1a1a1a;"></div>
    </div>

</div>

<script>
const API = 'ai-system/api.php';
let activeWorkers = [];
let spyUser = null;

async function loadData() {
    const res = await fetch(API + '?action=get_admin_data');
    const data = await res.json();
    
    // 1. עדכון רשימת עובדים
    activeWorkers = data.active_workers;
    const wList = document.getElementById('workersList');
    wList.innerHTML = activeWorkers.length ? '' : '<div style="padding:10px; color:gray;">אין עובדים מחוברים...</div>';
    
    activeWorkers.forEach(w => {
        wList.innerHTML += `<div style="padding:5px; color:#0f0;">💻 ${w} <span class="status-dot online"></span></div>`;
    });

    // 2. עדכון רשימת משתמשים וניתוב
    const uList = document.getElementById('usersList');
    uList.innerHTML = '';
    
    // המרת אובייקט המשתמשים למערך
    for (const [username, userData] of Object.entries(data.users)) {
        if(username === 'ormalka') continue; // הסתרת המנהל
        
        let workerOptions = `<option value="auto" ${userData.assigned_worker === 'auto' ? 'selected' : ''}>🤖 אוטומטי (מי שפנוי)</option>`;
        
        // הוספת עובדים פעילים לרשימה
        activeWorkers.forEach(w => {
            let isSel = userData.assigned_worker === w ? 'selected' : '';
            workerOptions += `<option value="${w}" ${isSel}>💻 ${w}</option>`;
        });

        uList.innerHTML += `
            <div class="user-row" onclick="startSpy('${username}')">
                <div style="display:flex; justify-content:space-between;">
                    <b>👤 ${username}</b>
                    <span onclick="delUser('${username}', event)" style="color:red; cursor:pointer;">✖</span>
                </div>
                <select class="worker-select" onchange="assignWorker('${username}', this.value)" onclick="event.stopPropagation()">
                    ${workerOptions}
                </select>
            </div>`;
    }

    // 3. הגדרות
    document.getElementById('chkInternet').checked = data.settings.internet;
    document.getElementById('chkNsfw').checked = data.settings.nsfw;
}

async function assignWorker(username, workerName) {
    await fetch(API + '?action=assign_worker', {
        method:'POST',
        headers: {'Content-Type': 'application/json'},
        body:JSON.stringify({username: username, worker: workerName})
    });
    // לא מרעננים הכל כדי לא להרוס את חווית המשתמש, השרת שומר
}

async function saveSettings() {
    await fetch(API + '?action=update_settings', {
        method:'POST',
        headers: {'Content-Type': 'application/json'},
        body:JSON.stringify({
            internet: document.getElementById('chkInternet').checked,
            nsfw: document.getElementById('chkNsfw').checked,
            default_model: 'standard'
        })
    });
}

// שליחת פקודה כמנהל
async function sendAdmin() {
    const txt = document.getElementById('adminInput').value;
    if(!txt) return;
    document.getElementById('adminInput').value = '';
    await fetch(API + '?action=create_task', {
        method:'POST',
        headers: {'Content-Type': 'application/json'},
        body:JSON.stringify({prompt:txt, tool:'admin', model_type:'uncensored'}) 
    });
    loadMyChat();
}

function startSpy(u) { spyUser = u; document.getElementById('spyName').innerText = u; loadSpyChat(); }

async function loadSpyChat() {
    if(!spyUser) return;
    const res = await fetch(API + '?action=get_chat_history', {
        method:'POST', headers: {'Content-Type': 'application/json'},
        body:JSON.stringify({target_user: spyUser})
    });
    const msgs = await res.json();
    const area = document.getElementById('spyChat');
    area.innerHTML = '';
    msgs.forEach(m => {
        area.innerHTML += `<div style="font-size:12px; margin-bottom:5px; padding:5px; background:${m.sender=='user'?'#333':'#222'}; border-radius:5px;">
            <b style="color:${m.sender=='user'?'cyan':'lime'}">${m.sender}:</b> ${m.text}
        </div>`;
    });
    area.scrollTop = area.scrollHeight;
}

async function loadMyChat() {
    const res = await fetch(API + '?action=get_chat_history'); 
    const msgs = await res.json();
    const area = document.getElementById('myChat');
    area.innerHTML = '';
    msgs.forEach(m => area.innerHTML += `<div style="margin-bottom:5px; color:${m.sender=='user'?'#fff':'#0f0'};"><b>${m.sender}:</b> ${m.text}</div>`);
    area.scrollTop = area.scrollHeight;
}

async function delUser(u, e) {
    e.stopPropagation();
    if(confirm('למחוק את המשתמש וההיסטוריה שלו?')) {
        await fetch(API + '?action=delete_user', {method:'POST', body:JSON.stringify({username:u})});
        loadData();
    }
}

// רענון נתונים כל 2 שניות
setInterval(() => { loadData(); loadMyChat(); loadSpyChat(); }, 2000);
loadData(); loadMyChat();
</script>
</body>
</html>