<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$dataDir = __DIR__ . '/data';
if (!file_exists($dataDir)) mkdir($dataDir, 0777, true);

$files = [
    'users' => $dataDir . '/users.json',
    'tasks' => $dataDir . '/tasks.json',
    'chats' => $dataDir . '/chats',
    'settings' => $dataDir . '/settings.json',
    'workers' => $dataDir . '/workers.json' // קובץ חדש למעקב עובדים
];

if (!file_exists($files['chats'])) mkdir($files['chats'], 0777, true);

// יצירת קבצים חסרים
foreach (['users', 'tasks', 'settings', 'workers'] as $k) {
    if (!file_exists($files[$k])) file_put_contents($files[$k], json_encode([], JSON_UNESCAPED_UNICODE));
}

// הגדרות ברירת מחדל
if (filesize($files['settings']) < 5) {
    file_put_contents($files['settings'], json_encode([
        'internet' => true, 
        'nsfw' => false,
        'default_model' => 'standard'
    ], JSON_UNESCAPED_UNICODE));
}

$action = $_GET['action'] ?? '';
$input = json_decode(file_get_contents('php://input'), true);

// --- 1. דופק עובד (Heartbeat) ---
if ($action === 'heartbeat') {
    $name = $input['name'];
    $workers = json_decode(file_get_contents($files['workers']), true);
    
    // עדכון זמן אחרון שנראה
    $workers[$name] = [
        'last_seen' => time(),
        'status' => 'online'
    ];
    
    // ניקוי עובדים מתים (שלא נראו דקה)
    foreach ($workers as $wName => $data) {
        if (time() - $data['last_seen'] > 60) unset($workers[$wName]);
    }
    
    file_put_contents($files['workers'], json_encode($workers, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo json_encode(['status'=>'ok']); exit;
}

// --- 2. יצירת משימה עם ניתוב ---
if ($action === 'create_task') {
    if (!isset($_SESSION['user'])) exit;
    
    $users = json_decode(file_get_contents($files['users']), true);
    $currentUser = $_SESSION['user'];
    
    // בדיקה אם למשתמש הוקצה עובד ספציפי
    $assignedWorker = 'auto';
    if (isset($users[$currentUser]) && isset($users[$currentUser]['assigned_worker'])) {
        $assignedWorker = $users[$currentUser]['assigned_worker'];
    }

    $tasks = json_decode(file_get_contents($files['tasks']), true);
    $newTask = [
        'id' => uniqid(),
        'user' => $currentUser,
        'prompt' => $input['prompt'],
        'tool' => $input['tool'],
        'model_type' => $input['model_type'],
        'target_worker' => $assignedWorker, // כאן הניתוב נכנס לפעולה
        'status' => 'pending',
        'time' => date('H:i')
    ];
    
    // שמירה בהיסטוריה
    $histFile = $files['chats'] . '/' . md5($currentUser) . '.json';
    $hist = file_exists($histFile) ? json_decode(file_get_contents($histFile), true) : [];
    $hist[] = ['sender'=>'user', 'text'=>$input['prompt'], 'tool'=>$input['tool'], 'time'=>date("H:i")];
    file_put_contents($histFile, json_encode($hist, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    $tasks[] = $newTask;
    file_put_contents($files['tasks'], json_encode($tasks, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    
    echo json_encode(['status'=>'created', 'id'=>$newTask['id']]); exit;
}

// --- 3. משיכת משימה ע"י עובד ---
if ($action === 'poll_task') {
    $tasks = json_decode(file_get_contents($files['tasks']), true);
    $workerName = $input['name'] ?? 'Unknown';
    
    // עדכון דופק גם בזמן משיכה
    $workers = json_decode(file_get_contents($files['workers']), true);
    $workers[$workerName] = ['last_seen' => time(), 'status' => 'working'];
    file_put_contents($files['workers'], json_encode($workers, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    foreach ($tasks as $i => $task) {
        if ($task['status'] === 'pending') {
            // לוגיקת ניתוב: האם המשימה מיועדת לי?
            // אם המשימה היא "auto", כל עובד יכול לקחת.
            // אם המשימה היא לעובד ספציפי, רק הוא יכול לקחת.
            if ($task['target_worker'] !== 'auto' && $task['target_worker'] !== $workerName) {
                continue; // דלג, זה לא בשבילי
            }
            
            $tasks[$i]['status'] = 'processing';
            $tasks[$i]['worker'] = $workerName;
            file_put_contents($files['tasks'], json_encode($tasks, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            echo json_encode(['task' => $tasks[$i]], JSON_UNESCAPED_UNICODE); exit;
        }
    }
    echo json_encode(['task'=>null]); exit;
}

// --- ניהול: קבלת נתונים מלאים ---
if ($action === 'get_admin_data') {
    if (!isset($_SESSION['admin'])) exit;
    $users = json_decode(file_get_contents($files['users']), true);
    $settings = json_decode(file_get_contents($files['settings']), true);
    $workers = json_decode(file_get_contents($files['workers']), true);
    
    // סינון עובדים לא פעילים לתצוגה
    $activeWorkers = [];
    foreach($workers as $name => $data) {
        if(time() - $data['last_seen'] < 120) $activeWorkers[] = $name; // נחשב פעיל אם נראה ב-2 דקות אחרונות
    }

    echo json_encode([
        'users' => $users, 
        'settings' => $settings,
        'active_workers' => $activeWorkers
    ]); exit;
}

// --- ניהול: הקצאת עובד למשתמש ---
if ($action === 'assign_worker') {
    if (!isset($_SESSION['admin'])) exit;
    $targetUser = $input['username'];
    $workerName = $input['worker']; // יכול להיות 'auto' או שם של עובד
    
    $users = json_decode(file_get_contents($files['users']), true);
    if(isset($users[$targetUser])) {
        $users[$targetUser]['assigned_worker'] = $workerName;
        file_put_contents($files['users'], json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    echo json_encode(['status'=>'saved']); exit;
}

// --- שאר הפונקציות הרגילות ---
if ($action === 'login') {
    $u=$input['username']; $p=$input['password'];
    if($u==='ormalka' && $p==='ormalka2000'){ $_SESSION['user']='ormalka'; $_SESSION['admin']=true; echo json_encode(['status'=>'ok','isAdmin'=>true]); exit; }
    $users=json_decode(file_get_contents($files['users']),true);
    if(isset($users[$u])) {
        $h=is_array($users[$u])?$users[$u]['pass']:$users[$u];
        if(password_verify($p,$h)){ $_SESSION['user']=$u; $_SESSION['admin']=false; echo json_encode(['status'=>'ok','isAdmin'=>false]); exit; }
    }
    echo json_encode(['status'=>'error', 'message'=>'פרטים שגויים']); exit;
}
if ($action === 'register') {
    $u=$input['username']; $p=$input['password'];
    $users=json_decode(file_get_contents($files['users']),true);
    if(isset($users[$u])){echo json_encode(['status'=>'error', 'message'=>'תפוס']);exit;}
    $users[$u]=['pass'=>password_hash($p,PASSWORD_DEFAULT),'role'=>'user','assigned_worker'=>'auto'];
    file_put_contents($files['users'],json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $_SESSION['user']=$u; echo json_encode(['status'=>'ok']); exit;
}
if ($action === 'logout') { session_destroy(); echo json_encode(['status'=>'ok']); exit; }
if ($action === 'submit_result') {
    $tasks = json_decode(file_get_contents($files['tasks']), true);
    foreach ($tasks as $i => $task) {
        if ($task['id'] === $input['id']) {
            $tasks[$i]['status'] = 'done'; 
            $tasks[$i]['result'] = $input['result'];
            file_put_contents($files['tasks'], json_encode($tasks, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            $histFile = $files['chats'] . '/' . md5($task['user']) . '.json';
            $hist = file_exists($histFile) ? json_decode(file_get_contents($histFile), true) : [];
            $hist[] = ['sender'=>'ai', 'text'=>$input['result'], 'worker'=>$input['worker']??'AI', 'time'=>date("H:i")];
            file_put_contents($histFile, json_encode($hist, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            break;
        }
    }
    echo json_encode(['status'=>'saved']); exit;
}
if ($action === 'load_history') {
    $f = $files['chats'] . '/' . md5($_SESSION['user']) . '.json';
    echo file_exists($f) ? file_get_contents($f) : '[]'; exit;
}
if ($action === 'check_status') {
    $tasks = json_decode(file_get_contents($files['tasks']), true);
    foreach($tasks as $t) if($t['id'] === $_GET['id']) { echo json_encode($t, JSON_UNESCAPED_UNICODE); exit; }
    echo json_encode(['status'=>'wait']); exit;
}
if ($action === 'get_chat_history') {
    if (!isset($_SESSION['admin'])) exit;
    $f = $files['chats'] . '/' . md5($input['target_user']) . '.json';
    echo file_exists($f) ? file_get_contents($f) : '[]'; exit;
}
if ($action === 'delete_user') {
    if (!isset($_SESSION['admin'])) exit;
    $u=$input['username']; $users=json_decode(file_get_contents($files['users']),true); unset($users[$u]);
    file_put_contents($files['users'],json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo json_encode(['status'=>'deleted']); exit;
}
if ($action === 'update_settings') {
    if (!isset($_SESSION['admin'])) exit;
    file_put_contents($files['settings'], json_encode($input, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo json_encode(['status'=>'saved']); exit;
}
?>