const API = 'ai-system/api.php';
const msgs = document.getElementById('messagesArea');
const typing = document.getElementById('typingIndicator');
const workerDisp = document.getElementById('workerDisplay');

async function loadHistory() {
    try {
        const res = await fetch(API + '?action=load_history');
        const data = await res.json();
        msgs.innerHTML = '';
        data.forEach(m => addMsg(m.text, m.sender, m.worker));
        msgs.scrollTop = msgs.scrollHeight;
    } catch(e) {}
}
loadHistory();

async function send() {
    const inp = document.getElementById('userInput');
    const txt = inp.value.trim();
    if(!txt) return;
    
    const tool = document.getElementById('toolSelect').value;
    const model = document.getElementById('modelSelect').value;
    
    addMsg(txt, 'user', null, tool);
    inp.value = '';
    typing.style.display = 'block';
    
    const res = await fetch(API + '?action=create_task', {
        method:'POST', 
        headers: {'Content-Type': 'application/json'},
        body:JSON.stringify({
            prompt: txt, 
            tool: tool,        
            model_type: model
        })
    });
    const data = await res.json();
    
    if(data.status === 'created') {
        const interval = setInterval(async ()=>{
            const r = await fetch(API + '?action=check_status&id='+data.id);
            const task = await r.json();
            
            if(task.worker) {
                let statusText = "מחובר ל: " + task.worker;
                if(task.model_type === 'dark') statusText += " (😈 DARK)";
                else if(task.model_type === 'uncensored') statusText += " (🐬 FREE)";
                document.getElementById('workerDisplay').innerText = statusText;
            }

            if(task.status === 'done') {
                clearInterval(interval);
                typing.style.display = 'none';
                addMsg(task.result, 'ai', task.worker);
            }
        }, 1000);
    }
}

function addMsg(txt, sender, workerName) {
    const d = document.createElement('div');
    d.className = `msg ${sender}`;
    
    // תיקון קישורים: המרת ירידות שורה בלבד, השארת HTML כמו שהוא
    let html = txt.replace(/\n/g, '<br>');
    
    if(html.includes("### FILE:")) html = "✅ <b>קבצים נוצרו בשרת.</b>";
    
    if(sender === 'ai' && workerName) {
        html += `<div style="font-size:9px; opacity:0.6; margin-top:5px; border-top:1px solid rgba(255,255,255,0.1); padding-top:2px;">${workerName}</div>`;
    }
    
    d.innerHTML = html;
    msgs.appendChild(d);
    msgs.scrollTop = msgs.scrollHeight;
}