<?php 
session_start(); 
if(!isset($_SESSION['user'])) header("Location: index.php"); 
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html dir="rtl" lang="he">
<head>
    <meta charset="UTF-8">
    <title>AI Chat Ultimate</title>
    <link rel="stylesheet" href="ai-system/style.css">
</head>
<body>
<div class="wrapper">
    <div class="header">
        <div>
            <div style="font-weight:bold; font-size:18px;"><?php echo $_SESSION['user']; ?></div>
            <div id="workerDisplay" style="font-size:11px; color:#aaffaa;">ממתין לעובד...</div>
        </div>
        <div style="display:flex; gap:10px;">
             <?php if(isset($_SESSION['admin']) && $_SESSION['admin']): ?>
                <a href="admin.php" style="background:red; color:white; padding:5px 10px; text-decoration:none; border-radius:5px; font-size:12px;">ניהול</a>
            <?php endif; ?>
            <button onclick="location.href='ai-system/api.php?action=logout';location.href='index.php'" style="width:auto; padding:5px 10px; background:#444;">יציאה</button>
        </div>
    </div>
    
    <div class="chat-area" id="messagesArea"></div>
    <div id="typingIndicator" class="typing" style="display:none;"><span></span><span></span><span></span> AI חושב...</div>

    <div class="controls" style="padding:15px; background:rgba(0,0,0,0.3); border-top:1px solid rgba(255,255,255,0.1);">
        <div style="display:flex; gap:10px; margin-bottom:10px;">
            
            <div style="flex:2;">
                <label style="font-size:11px; color:#aaa; display:block; margin-bottom:3px;">בחר כלי:</label>
                <select id="toolSelect" style="width:100%; padding:8px; border-radius:5px; background:#e3f2fd; color:#0d47a1; font-weight:bold; border:none;">
                    <option value="chat">💬 צ'אט רגיל</option>
                    <option value="image">📷 יצירת תמונות</option>
                    <option value="video">🎬 חיפוש וידאו</option>
                    <option value="scan">🛡️ סריקת אתר</option>
                    <option value="app_builder">📱 בניית אפליקציה</option>
                    <?php if(isset($_SESSION['admin']) && $_SESSION['admin']): ?>
                        <option value="admin">⚡ עריכת קבצים (ROOT)</option>
                    <?php endif; ?>
                </select>
            </div>

            <div style="flex:1;">
                <label style="font-size:11px; color:#aaa; display:block; margin-bottom:3px;">בחר מודל:</label>
                <select id="modelSelect" style="width:100%; padding:8px; border-radius:5px; background:#ffebee; color:#b71c1c; font-weight:bold; border:none;">
                    <option value="standard">🤖 רגיל</option>
                    <option value="uncensored">🐬 Uncensored</option>
                    <option value="dark">😈 Dark (החדש!)</option>
                </select>
            </div>
        </div>
    </div>

    <div class="input-zone">
        <input type="text" id="userInput" placeholder="הקלד כאן..." autocomplete="off" onkeypress="if(event.key==='Enter') send()">
        <button onclick="send()">➤</button>
    </div>
</div>
<script src="ai-system/chat.js"></script>
</body></html>