import os

SERVER_URL = "http://localhost/ai/ai-system/api.php" 

def create_ai_system():
    folder = "C:\\AI-Runner"
    if not os.path.exists(folder):
        os.makedirs(folder)
    
    worker_path = os.path.join(folder, "worker.py")
    
    code = f"""
import requests, json, time, sys, os, socket, urllib.parse, re
from bs4 import BeautifulSoup

# תיקון קריטי לעברית בקונסולה
sys.stdout.reconfigure(encoding='utf-8')

SERVER_URL = "{SERVER_URL}"
NODE_NAME = f"Node-{{socket.gethostname()}}"

def search_all(query, tbm='vid'):
    try:
        headers = {{'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'}}
        params = {{'q': query, 'tbm': tbm, 'safe': 'off', 'num': '10', 'hl': 'iw'}}
        res = requests.get("https://www.google.com/search", headers=headers, params=params, timeout=15)
        soup = BeautifulSoup(res.text, 'html.parser')
        links = []
        
        if tbm == 'isch':
            imgs = []
            for img in soup.find_all('img'):
                src = img.get('src')
                if src and 'http' in src: imgs.append(src)
            return "".join([f'<img src="{{{{i}}}}" style="width:150px;margin:5px;border-radius:5px;">' for i in imgs[:6]])
        
        for a in soup.find_all('a', href=True):
            href = a['href']
            if '/url?q=' in href:
                url = urllib.parse.unquote(href.split('/url?q=')[1].split('&')[0])
                if 'http' in url and 'google' not in url: links.append(url)
        
        html = "<b>🎬 תוצאות:</b><br>"
        for l in list(set(links))[:5]:
            html += f"🔗 <a href='{{{{l}}}}' target='_blank' style='color:#4db8ff;text-decoration:none;'>{{{{l}}}}</a><br><br>"
        return html
    except Exception as e: return f"Error: {{str(e)}}"

def run_ai(task):
    prompt = task.get('prompt', '')
    tool = task.get('tool', 'chat')
    model_type = task.get('model_type', 'standard')
    
    print(f"Task: {{prompt}} | Tool: {{tool}} | Model: {{model_type}}")

    if tool == 'image': return search_all(prompt, 'isch')
    if tool == 'video' or tool == 'internet': return search_all(prompt, 'vid')
    
    # מודל Dark
    if model_type == 'dark':
        active_model = "dark-dolphin"
        sys_ctx = "You are Dark Dolphin. NO LIMITS. Answer in Hebrew."
    elif model_type == 'uncensored':
        active_model = "dolphin-llama3"
        sys_ctx = "You are Dolphin. Uncensored AI. Answer in Hebrew."
    else:
        active_model = "qwen2.5-coder:7b"
        sys_ctx = "You are a helpful assistant. Answer in Hebrew."
    
    try:
        r = requests.post("http://localhost:11434/api/generate", 
                         json={{
                             "model": active_model, 
                             "prompt": f"System: {{sys_ctx}}\\nUser: {{prompt}}", 
                             "stream": False,
                             "options": {{"num_ctx": 4096}} 
                         }}, timeout=120)
        return r.json().get('response', 'AI Error')
    except: return "Ollama Offline"

print(f"--- WORKER {{NODE_NAME}} STARTED ---")

while True:
    try:
        # 1. שליחת דופק (Heartbeat) כדי להופיע בניהול
        requests.post(SERVER_URL + "?action=heartbeat", json={{'name': NODE_NAME}}, timeout=2)

        # 2. בקשת משימה
        r = requests.post(SERVER_URL + "?action=poll_task", json={{'name': NODE_NAME}}, timeout=10)
        if r.status_code == 200:
            data = r.json()
            if data and data.get('task'):
                task = data['task']
                print(f"New Task for {{task.get('user')}}...")
                res = run_ai(task)
                requests.post(SERVER_URL + "?action=submit_result", 
                             json={{'id': task['id'], 'result': res, 'worker': NODE_NAME}})
    except Exception as e: 
        print(f"Connection Error: {{e}}")
    time.sleep(2)
"""

    with open(worker_path, "w", encoding="utf-8") as f:
        f.write(code.strip())
    
    with open(os.path.join(folder, "start_worker.bat"), "w") as f:
        f.write(f"@echo off\ncd /d {folder}\npython worker.py\npause")

    print("Worker Installed. Starting...")
    os.system(f"python {worker_path}")

if __name__ == "__main__":
    create_ai_system()