<?php header('Content-Type: text/html; charset=utf-8'); ?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>כניסה</title>
    <link rel="stylesheet" href="ai-system/style.css">
</head>
<body>
<div class="wrapper" style="justify-content:center;">
    <div class="auth-box" id="login">
        <h2>🚀 התחברות</h2>
        <input type="text" id="l_u" placeholder="שם משתמש">
        <input type="password" id="l_p" placeholder="סיסמה">
        <button onclick="auth('login')">כנס</button>
        <button class="secondary" onclick="toggle()">הרשמה</button>
    </div>
    <div class="auth-box" id="reg" style="display:none;">
        <h2>✨ הרשמה</h2>
        <input type="text" id="r_u" placeholder="בחר שם משתמש">
        <input type="password" id="r_p" placeholder="בחר סיסמה">
        <button onclick="auth('register')">צור חשבון</button>
        <button class="secondary" onclick="toggle()">חזור</button>
    </div>
</div>
<script>
async function auth(act) {
    const u = document.getElementById(act=='login'?'l_u':'r_u').value;
    const p = document.getElementById(act=='login'?'l_p':'r_p').value;
    const res = await fetch('ai-system/api.php?action='+act, {
        method:'POST', 
        headers: {'Content-Type': 'application/json'},
        body:JSON.stringify({username:u, password:p})
    });
    const d = await res.json();
    if(d.status=='ok') location.href = d.isAdmin ? 'admin.php' : 'chat.php';
    else alert(d.message || 'שגיאה');
}
function toggle() { 
    document.getElementById('login').style.display = document.getElementById('login').style.display=='none'?'block':'none';
    document.getElementById('reg').style.display = document.getElementById('reg').style.display=='none'?'block':'none';
}
</script>
</body></html>