<?php session_start(); if(!isset($_SESSION['admin'])) header("Location: index.php"); ?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>GOD MODE ADMIN</title>
    <link rel="stylesheet" href="ai-system/style.css">
    <style>
        body { margin:0; overflow:hidden; display:flex; flex-direction:column; height:100vh; background:#111; color:white; }
        .top-bar { background:#222; padding:10px; display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid #444; }
        .main-grid { display:grid; grid-template-columns: 300px 1fr 300px; flex:1; overflow:hidden; }
        .panel { border-left:1px solid #333; display:flex; flex-direction:column; background:rgba(0,0,0,0.2); }
        .panel-head { background:#1a1a1a; padding:10px; font-weight:bold; border-bottom:1px solid #333; }
        .scroll-area { flex:1; overflow-y:auto; padding:10px; }
        .setting-row { padding:10px; border-bottom:1px solid #333; display:flex; justify-content:space-between; align-items:center; }
        .user-row { padding:8px; cursor:pointer; border-bottom:1px solid #333; display:flex; justify-content:space-between; }
        .user-row:hover { background:#333; }
    </style>
</head>
<body>

<div class="top-bar">
    <div>⚡ <b>GOD MODE</b> | מחובר כ: ormalka</div>
    <button onclick="location.href='index.php'" style="background:red; width:auto; padding:5px 15px;">יציאה</button>
</div>

<div class="main-grid">
    
    <div class="panel">
        <div class="panel-head">🎛️ הגדרות עובדים</div>
        
        <div class="setting-row">
            <span>🌐 גישת אינטרנט</span>
            <input type="checkbox" id="chkInternet" onchange="saveSettings()">
        </div>
        <div class="setting-row">
            <span>🔞 עוקף צנזורה (Jailbreak)</span>
            <input type="checkbox" id="chkNsfw" onchange="saveSettings()">
        </div>
        
        <div class="setting-row" style="flex-direction:column; align-items:flex-start;">
            <span style="margin-bottom:5px;">🤖 מודל ברירת מחדל לעובדים:</span>
            <select id="selDefaultModel" onchange="saveSettings()" style="width:100%; padding:5px; background:#333; color:white; border:none;">
                <option value="standard">Standard (Qwen - חכם)</option>
                <option value="uncensored">Uncensored (Dolphin - פרוץ)</option>
            </select>
        </div>
        
        <div class="panel-head" style="margin-top:20px;">👥 משתמשים</div>
        <div id="usersList" class="scroll-area"></div>
    </div>

    <div class="panel">
        <div class="panel-head">⚡ מסוף עריכה (ROOT SHELL)</div>
        <div id="myChat" class="scroll-area" style="background:black; font-family:monospace;"></div>
        <div class="input-zone">
            <input type="text" id="adminInput" placeholder="ערוך אתר / פקודה..." onkeypress="if(event.key==='Enter') sendAdmin()">
            <button onclick="sendAdmin()">🚀</button>
        </div>
    </div>

    <div class="panel">
        <div class="panel-head">👁️ ריגול: <span id="spyName">בחר משתמש</span></div>
        <div id="spyChat" class="scroll-area" style="background:#1a1a1a;"></div>
    </div>

</div>

<script>
const API = 'ai-system/api.php';
let spyUser = null;

async function loadData() {
    const res = await fetch(API + '?action=get_admin_data');
    const data = await res.json();
    
    document.getElementById('chkInternet').checked = data.settings.internet;
    document.getElementById('chkNsfw').checked = data.settings.nsfw;
    document.getElementById('selDefaultModel').value = data.settings.default_model || 'standard';
    
    const uList = document.getElementById('usersList');
    uList.innerHTML = '';
    data.users.forEach(u => {
        if(u === 'ormalka') return;
        uList.innerHTML += `
            <div class="user-row" onclick="startSpy('${u}')">
                <span>👤 ${u}</span>
                <span onclick="delUser('${u}', event)" style="color:red; font-weight:bold;">X</span>
            </div>`;
    });
}

async function saveSettings() {
    await fetch(API + '?action=update_settings', {
        method:'POST',
        body:JSON.stringify({
            internet: document.getElementById('chkInternet').checked,
            nsfw: document.getElementById('chkNsfw').checked,
            default_model: document.getElementById('selDefaultModel').value
        })
    });
}

async function loadMyChat() {
    const res = await fetch(API + '?action=get_chat_history'); 
    const msgs = await res.json();
    const area = document.getElementById('myChat');
    area.innerHTML = '';
    msgs.forEach(m => {
        area.innerHTML += `<div style="margin-bottom:5px; color:${m.sender=='user'?'#fff':'#0f0'};">
            <b>${m.sender}:</b> ${m.text}
        </div>`;
    });
    area.scrollTop = area.scrollHeight;
}

async function sendAdmin() {
    const txt = document.getElementById('adminInput').value;
    if(!txt) return;
    document.getElementById('adminInput').value = '';
    
    // מנהל תמיד ב-Mode Admin כדי לערוך
    await fetch(API + '?action=create_task', {
        method:'POST',
        body:JSON.stringify({prompt:txt, tool:'admin', model_type:'uncensored'}) 
    });
    loadMyChat();
}

function startSpy(u) { spyUser = u; document.getElementById('spyName').innerText = u; loadSpyChat(); }

async function loadSpyChat() {
    if(!spyUser) return;
    const res = await fetch(API + '?action=get_chat_history', {method:'POST', body:JSON.stringify({target_user: spyUser})});
    const msgs = await res.json();
    const area = document.getElementById('spyChat');
    area.innerHTML = '';
    msgs.forEach(m => {
        area.innerHTML += `<div style="font-size:12px; margin-bottom:5px; padding:5px; background:${m.sender=='user'?'#333':'#222'}; border-radius:5px;">
            <b>${m.sender}:</b> ${m.text}
        </div>`;
    });
    area.scrollTop = area.scrollHeight;
}

async function delUser(u, e) {
    e.stopPropagation();
    if(confirm('למחוק?')) {
        await fetch(API + '?action=delete_user', {method:'POST', body:JSON.stringify({username:u})});
        loadData();
    }
}

setInterval(() => { loadMyChat(); loadSpyChat(); }, 2000);
loadData(); loadMyChat();
</script>
</body>
</html>