<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$dataDir = __DIR__ . '/data';
if (!file_exists($dataDir)) mkdir($dataDir, 0777, true);

$usersFile = $dataDir . '/users.json';
$tasksFile = $dataDir . '/tasks.json';
$chatsDir  = $dataDir . '/chats';
$settingsFile = $dataDir . '/settings.json';

if (!file_exists($chatsDir)) mkdir($chatsDir, 0777, true);
if (!file_exists($usersFile)) file_put_contents($usersFile, json_encode([]));
if (!file_exists($tasksFile)) file_put_contents($tasksFile, json_encode([]));

// הגדרות ברירת מחדל (כולל מודל ברירת מחדל)
if (!file_exists($settingsFile)) {
    file_put_contents($settingsFile, json_encode([
        'internet' => true, 
        'nsfw' => false,
        'default_model' => 'standard' // standard / uncensored
    ]));
}

$action = $_GET['action'] ?? '';
$input = json_decode(file_get_contents('php://input'), true);

// --- Login / Register ---
if ($action === 'login') {
    $u=$input['username']; $p=$input['password'];
    if($u==='ormalka' && $p==='ormalka2000'){ $_SESSION['user']='ormalka'; $_SESSION['admin']=true; echo json_encode(['status'=>'ok','isAdmin'=>true]); exit; }
    $users=json_decode(file_get_contents($usersFile),true);
    if(isset($users[$u])) {
        $h=is_array($users[$u])?$users[$u]['pass']:$users[$u];
        if(password_verify($p,$h)){ $_SESSION['user']=$u; $_SESSION['admin']=false; echo json_encode(['status'=>'ok','isAdmin'=>false]); exit; }
    }
    echo json_encode(['status'=>'error']); exit;
}
if ($action === 'register') {
    $u=$input['username']; $p=$input['password'];
    $users=json_decode(file_get_contents($usersFile),true);
    if(isset($users[$u])){echo json_encode(['status'=>'error']);exit;}
    $users[$u]=['pass'=>password_hash($p,PASSWORD_DEFAULT),'assigned_worker'=>'auto'];
    file_put_contents($usersFile,json_encode($users));
    $_SESSION['user']=$u; echo json_encode(['status'=>'ok']); exit;
}
if ($action === 'logout') { session_destroy(); echo json_encode(['status'=>'ok']); exit; }

// --- Create Task (עם תמיכה בכלים חדשים) ---
if ($action === 'create_task') {
    if (!isset($_SESSION['user'])) exit;
    
    $settings = json_decode(file_get_contents($settingsFile), true);
    $users = json_decode(file_get_contents($usersFile), true);
    $currentUser = $_SESSION['user'];
    
    // קביעת העובד והמודל
    $targetWorker = isset($users[$currentUser]) && is_array($users[$currentUser]) ? ($users[$currentUser]['assigned_worker'] ?? 'auto') : 'auto';
    
    // אם המשתמש לא בחר מודל ספציפי, משתמשים בברירת המחדל של המנהל
    $modelToUse = $input['model_type'] ?? $settings['default_model'];

    $newTask = [
        'id' => uniqid(),
        'user' => $currentUser,
        'prompt' => $input['prompt'],
        'tool' => $input['tool'], // video, image, scan, app, presentation, admin
        'model_type' => $modelToUse,
        'target_worker' => $targetWorker,
        'settings' => $settings,
        'status' => 'pending'
    ];
    
    // שמירה בהיסטוריה
    $histFile = $chatsDir . '/' . md5($currentUser) . '.json';
    $hist = file_exists($histFile) ? json_decode(file_get_contents($histFile), true) : [];
    $hist[] = ['sender'=>'user', 'text'=>$input['prompt'], 'tool'=>$input['tool'], 'time'=>date("H:i")];
    file_put_contents($histFile, json_encode($hist));

    $tasks = json_decode(file_get_contents($tasksFile), true);
    $tasks[] = $newTask;
    file_put_contents($tasksFile, json_encode($tasks));
    
    echo json_encode(['status'=>'created', 'id'=>$newTask['id']]);
    exit;
}

// --- ניהול (Admin Data) ---
if ($action === 'get_admin_data') {
    if (!isset($_SESSION['admin'])) exit;
    $users = json_decode(file_get_contents($usersFile), true);
    $settings = json_decode(file_get_contents($settingsFile), true);
    $uList = [];
    foreach($users as $u => $v) $uList[] = $u;
    echo json_encode(['users'=>$uList, 'settings'=>$settings]);
    exit;
}

if ($action === 'update_settings') {
    if (!isset($_SESSION['admin'])) exit;
    file_put_contents($settingsFile, json_encode($input));
    echo json_encode(['status'=>'saved']);
    exit;
}

// --- שאר הפונקציות (ללא שינוי מהותי) ---
if ($action === 'poll_task') {
    if (!file_exists($tasksFile)) { echo json_encode(['task'=>null]); exit; }
    $tasks = json_decode(file_get_contents($tasksFile), true);
    $wn = $input['name'] ?? 'Unknown';
    foreach ($tasks as $i => $task) {
        if ($task['status'] === 'pending') {
            if ($task['target_worker'] !== 'auto' && $task['target_worker'] !== $wn) continue;
            $tasks[$i]['status'] = 'processing'; $tasks[$i]['worker'] = $wn;
            file_put_contents($tasksFile, json_encode($tasks));
            echo json_encode(['task' => $tasks[$i]]); exit;
        }
    }
    echo json_encode(['task'=>null]); exit;
}
if ($action === 'submit_result') {
    $tasks = json_decode(file_get_contents($tasksFile), true);
    foreach ($tasks as $i => $task) {
        if ($task['id'] === $input['id']) {
            $tasks[$i]['status'] = 'done'; $tasks[$i]['result'] = $input['result'];
            file_put_contents($tasksFile, json_encode($tasks));
            
            $histFile = $chatsDir . '/' . md5($task['user']) . '.json';
            $hist = file_exists($histFile) ? json_decode(file_get_contents($histFile), true) : [];
            $hist[] = ['sender'=>'ai', 'text'=>$input['result'], 'worker'=>$input['worker']??'AI', 'time'=>date("H:i")];
            file_put_contents($histFile, json_encode($hist));
            
            // יצירת קבצים (עריכת אתר / אפליקציות / מצגות)
            if ($task['tool'] === 'admin' || $task['tool'] === 'app_builder' || $task['tool'] === 'presentation') {
                 $matches = [];
                 preg_match_all('/### DIR: (.*?) ###/s', $input['result'], $dirs);
                 foreach ($dirs[1] as $d) { $p=dirname(__DIR__).'/'.trim($d); if(!file_exists($p)) mkdir($p,0777,true); }
                 preg_match_all('/### FILE: (.*?) ###\n(.*?)### END FILE ###/s', $input['result'], $matches, PREG_SET_ORDER);
                 foreach ($matches as $m) { $p=dirname(__DIR__).'/'.trim($m[1]); if(!file_exists(dirname($p))) mkdir(dirname($p),0777,true); file_put_contents($p,trim($m[2])); }
            }
            break;
        }
    }
    echo json_encode(['status'=>'saved']); exit;
}
if ($action === 'load_history') {
    if (!isset($_SESSION['user'])) exit;
    $f = $chatsDir . '/' . md5($_SESSION['user']) . '.json';
    echo file_exists($f) ? file_get_contents($f) : json_encode([]); exit;
}
if ($action === 'check_status') {
    $tasks = json_decode(file_get_contents($tasksFile), true);
    foreach($tasks as $t) if($t['id'] === $_GET['id']) { echo json_encode($t); exit; }
    echo json_encode(['status'=>'wait']); exit;
}
if ($action === 'get_chat_history') {
    if (!isset($_SESSION['admin'])) exit;
    $target = $input['target_user'] ?? $_SESSION['user'];
    $f = $chatsDir . '/' . md5($target) . '.json';
    echo file_exists($f) ? file_get_contents($f) : json_encode([]); exit;
}
if ($action === 'delete_user') {
    if (!isset($_SESSION['admin'])) exit;
    $u=$input['username']; $users=json_decode(file_get_contents($usersFile),true); unset($users[$u]);
    file_put_contents($usersFile,json_encode($users)); @unlink($chatsDir.'/'.md5($u).'.json');
    echo json_encode(['status'=>'deleted']); exit;
}
if ($action === 'heartbeat') { echo json_encode(['status'=>'ok']); exit; }
?>