<?php session_start(); if(!isset($_SESSION['user'])) header("Location: index.php"); ?>
<!DOCTYPE html>
<html dir="rtl"><head><meta charset="UTF-8"><title>AI Chat Ultimate</title><link rel="stylesheet" href="ai-system/style.css"></head><body>
<div class="wrapper">
    <div class="header">
        <div>
            <div style="font-weight:bold; font-size:18px;"><?php echo $_SESSION['user']; ?></div>
            <div id="workerDisplay" style="font-size:11px; color:#aaffaa;">????? ?????? ????...</div>
        </div>
        <div style="display:flex; gap:10px;">
             <?php if(isset($_SESSION['admin']) && $_SESSION['admin']): ?>
                <a href="admin.php" style="background:red; color:white; padding:5px 10px; text-decoration:none; border-radius:5px; font-size:12px;">?????</a>
            <?php endif; ?>
            <button onclick="location.href='ai-system/api.php?action=logout';location.href='index.php'" style="width:auto; padding:5px 10px; background:#444;">?????</button>
        </div>
    </div>
    
    <div class="chat-area" id="messagesArea"></div>
    <div id="typingIndicator" class="typing" style="display:none;"><span></span><span></span><span></span> ????? ???? ?????...</div>

    <div class="controls" style="padding:15px; background:rgba(0,0,0,0.3); border-top:1px solid rgba(255,255,255,0.1);">
        <div style="display:flex; gap:10px; margin-bottom:10px;">
            
            <div style="flex:2;">
                <label style="font-size:11px; color:#aaa; display:block; margin-bottom:3px;">??? ?? ??????</label>
                <select id="toolSelect" style="width:100%; padding:8px; border-radius:5px; background:#e3f2fd; color:#0d47a1; font-weight:bold; border:none;">
                    <option value="chat">?? ?'?? ????</option>
                    <option value="image">?? ????? ??????</option>
                    <option value="video">?? ????? ???????</option>
                    <option value="scan">??? ????? ????? (Hack Scan)</option>
                    <option value="app_builder">?? ????? ???????? (Android)</option>
                    <option value="presentation">?? ????? ???? HTML</option>
                    <?php if(isset($_SESSION['admin']) && $_SESSION['admin']): ?>
                        <option value="admin">? ????? ???? ??? (ROOT)</option>
                    <?php endif; ?>
                </select>
            </div>

            <div style="flex:1;">
                <label style="font-size:11px; color:#aaa; display:block; margin-bottom:3px;">?? ???? ????</label>
                <select id="modelSelect" style="width:100%; padding:8px; border-radius:5px; background:#ffebee; color:#b71c1c; font-weight:bold; border:none;">
                    <option value="standard">?? ???? (???)</option>
                    <option value="uncensored">?? ???? (Dolphin)</option>
                </select>
            </div>
        </div>
    </div>

    <div class="input-zone">
        <input type="text" id="userInput" placeholder="???? ???? ???..." autocomplete="off" onkeypress="if(event.key==='Enter') send()">
        <button onclick="send()">?</button>
    </div>
</div>

<script>
const API = 'ai-system/api.php';
const msgs = document.getElementById('messagesArea');
const typing = document.getElementById('typingIndicator');

async function loadHistory() {
    const res = await fetch(API + '?action=load_history');
    const data = await res.json();
    msgs.innerHTML = '';
    data.forEach(m => addMsg(m.text, m.sender, m.worker, m.tool));
    msgs.scrollTop = msgs.scrollHeight;
}
loadHistory();

async function send() {
    const inp = document.getElementById('userInput');
    const txt = inp.value.trim();
    if(!txt) return;
    
    // ????? ??????? ???? ????????
    const tool = document.getElementById('toolSelect').value;
    const model = document.getElementById('modelSelect').value;
    
    addMsg(txt, 'user', null, tool);
    inp.value = '';
    typing.style.display = 'block';
    
    const res = await fetch(API + '?action=create_task', {
        method:'POST', body:JSON.stringify({
            prompt: txt, 
            tool: tool,        // ???? ?????
            model_type: model  // ???? ?????
        })
    });
    const data = await res.json();
    
    if(data.status === 'created') {
        const interval = setInterval(async ()=>{
            const r = await fetch(API + '?action=check_status&id='+data.id);
            const task = await r.json();
            
            // ????? ????? ????
            if(task.worker) {
                let statusText = "????? ?'?: " + task.worker;
                if(task.model_type === 'uncensored') statusText += " (?? ????)";
                document.getElementById('workerDisplay').innerText = statusText;
            }

            if(task.status === 'done') {
                clearInterval(interval);
                typing.style.display = 'none';
                addMsg(task.result, 'ai', task.worker, task.tool);
            }
        }, 1000);
    }
}

function addMsg(txt, sender, worker, tool) {
    const d = document.createElement('div');
    d.className = `msg ${sender}`;
    let html = txt.replace(/\n/g, '<br>');
    
    // ????? ???? ?????
    if(html.includes("### FILE:")) html = "? <b>?????? ????? ???? ??????.</b>";
    
    // ?????? ???? ?????
    let icon = "";
    if(tool === 'video') icon = "?? ";
    if(tool === 'image') icon = "?? ";
    if(tool === 'scan') icon = "??? ";
    if(tool === 'app_builder') icon = "?? ";
    
    if(sender === 'user' && icon) html = icon + html;

    if(sender === 'ai' && worker) {
        html += `<div style="font-size:9px; opacity:0.6; margin-top:5px; border-top:1px solid rgba(255,255,255,0.1); padding-top:2px;">${worker}</div>`;
    }
    
    d.innerHTML = html;
    msgs.appendChild(d);
    msgs.scrollTop = msgs.scrollHeight;
}
</script>
</body></html>