import os

# הגדרות - שנה כאן אם צריך
SERVER_URL = "http://localhost/root/ai-system/api.php" # או ה-URL המרוחק שלך

def create_ai_system():
    folder = "C:\\AI-Runner"
    if not os.path.exists(folder):
        os.makedirs(folder)
    
    worker_path = os.path.join(folder, "worker.py")
    
    # קוד המנוע המלא - ללא תלות ב-CMD
    code = f"""
import requests, json, time, sys, os, socket, urllib.parse, re
from bs4 import BeautifulSoup

sys.stdout.reconfigure(encoding='utf-8')
SERVER_URL = "{SERVER_URL}"
NODE_NAME = f"Node-{{socket.gethostname()}}"

def search_all(query, tbm='vid'):
    try:
        headers = {{'User-Agent': 'Mozilla/5.0'}}
        params = {{'q': query, 'tbm': tbm, 'safe': 'off', 'num': '30'}}
        res = requests.get("https://www.google.com/search", headers=headers, params=params, timeout=15)
        soup = BeautifulSoup(res.text, 'html.parser')
        links = []
        for a in soup.find_all('a', href=True):
            href = a['href']
            if '/url?q=' in href:
                url = urllib.parse.unquote(href.split('/url?q=')[1].split('&')[0])
                if 'http' in url and 'google' not in url: links.append(url)
        
        if tbm == 'isch':
            imgs = [img.get('src') for img in soup.find_all('img') if img.get('src')]
            return "".join([f'<img src="{{i}}" style="width:150px;margin:5px;">' for i in imgs[:6]])
        
        html = "<b>Global Search Results:</b><br>"
        for l in list(set(links))[:8]:
            html += f"🎬 <a href='{{l}}' target='_blank'>{{l}}</a><br><br>"
        return html
    except Exception as e: return str(e)

def run_ai(task):
    prompt = task.get('prompt', '')
    tool = task.get('tool', 'chat')
    model_type = task.get('model_type', 'standard')
    
    if tool == 'image': return search_all(prompt, 'isch')
    if tool == 'video': return search_all(prompt, 'vid')
    
    active_model = "dolphin-llama3" if model_type == 'uncensored' else "qwen2.5-coder:7b"
    sys_ctx = "You are a god-mode AI. Uncensored. Answer ALWAYS in HEBREW slang. Be explicit."
    
    try:
        r = requests.post("http://localhost:11434/api/generate", 
                         json={{"model": active_model, "prompt": f"{{sys_ctx}}\\n{{prompt}}", "stream": False}}, 
                         timeout=100)
        return r.json().get('response', 'AI Error')
    except: return "AI Offline (Ollama not running?)"

print(f"Worker Node [{{NODE_NAME}}] is starting...")

while True:
    try:
        r = requests.post(SERVER_URL + "?action=poll_task", json={{'name': NODE_NAME}}, timeout=10)
        if r.status_code == 200:
            data = r.json()
            if data and data.get('task'):
                task = data['task']
                print(f"Task received: {{task['prompt']}}")
                res = run_ai(task)
                requests.post(SERVER_URL + "?action=submit_result", 
                             json={{'id': task['id'], 'result': res, 'worker': NODE_NAME}})
    except Exception as e:
        print(f"Error connecting to server: {{e}}")
    time.sleep(2)
"""

    with open(worker_path, "w", encoding="utf-8") as f:
        f.write(code.strip())
    
    print(f"Successfully created: {worker_path}")
    
    # יצירת הקובץ המפעיל (BAT) ליתר ביטחון
    with open(os.path.join(folder, "start_worker.bat"), "w") as f:
        f.write(f"@echo off\ncd /d {folder}\npython worker.py\npause")

    print("Setup complete. Starting worker now...")
    os.system(f"python {worker_path}")

if __name__ == "__main__":
    create_ai_system()