const API = 'ai-system/api.php';
const msgs = document.getElementById('messagesArea');
const typing = document.getElementById('typingIndicator');
const workerDisp = document.getElementById('workerDisplay');

async function loadHistory() {
    const res = await fetch(API + '?action=load_history');
    const data = await res.json();
    msgs.innerHTML = '';
    data.forEach(m => addMsg(m.text, m.sender, m.worker));
    msgs.scrollTop = msgs.scrollHeight;
}
loadHistory();

async function send() {
    const inp = document.getElementById('userInput');
    const mode = document.getElementById('modeSelect').value;
    const txt = inp.value.trim();
    if(!txt) return;
    
    addMsg(txt, 'user');
    inp.value = '';
    typing.style.display = 'block'; // הצגת אנימציה
    
    const res = await fetch(API + '?action=create_task', {
        method:'POST', body:JSON.stringify({prompt:txt, mode:mode})
    });
    const data = await res.json();
    
    if(data.status === 'created') {
        const interval = setInterval(async ()=>{
            const r = await fetch(API + '?action=check_status&id='+data.id);
            const task = await r.json();
            
            // עדכון מי העובד שמטפל
            if(task.worker) workerDisp.innerText = "מטופל ע'י: " + task.worker;
            
            if(task.status === 'done') {
                clearInterval(interval);
                typing.style.display = 'none'; // הסתרת אנימציה
                addMsg(task.result, 'ai', task.worker);
            }
        }, 1000);
    }
}

function addMsg(txt, sender, workerName) {
    const d = document.createElement('div');
    d.className = `msg ${sender}`;
    let html = txt.replace(/\n/g, '<br>');
    
    // זיהוי קבצים שנוצרו
    if(html.includes("### FILE:")) {
        html = "✅ <b>קבצי הפרויקט נוצרו בהצלחה בשרת.</b><br>גש לתיקיית הפרויקט כדי לפתוח ב-Android Studio.";
    }
    
    if(sender === 'ai' && workerName) {
        html += `<div style="font-size:9px; opacity:0.6; margin-top:5px;">נכתב ע'י: ${workerName}</div>`;
    }
    
    d.innerHTML = html;
    msgs.appendChild(d);
    msgs.scrollTop = msgs.scrollHeight;
}